# Changelog - Šumski Filter

## v3.0.0 - 2026-02-03

### ✨ Popup (jednostavnije)
- Pojednostavljen popup interfejs (bez suvišnih opcija)
- Fokus na osnovne akcije: uključi/isključi, prikaži sakrivene vesti, osveži

### 🐛 Popravke
- Ispravljeno ponašanje gde klikovi u popup-u nisu radili u nekim slučajevima

---

## v2.0.0 - 2026-02-03

### 🧠 Semantic Classification (AI-Powered)
- **NEW: Embedding-based classification** using OpenAI text-embedding-3-small
- Articles below keyword threshold are analyzed by the semantic classifier for binary decision
- 99 trained centroids across 10 content families:
  - **Negative**: cult_personality, fear_crisis, crna_hronika, economy_poverty, tabloid_sensationalism, political_theater, disinformation
  - **Positive**: constructive_journalism, civic_action, practical_guides
- Positive content detection prevents over-blocking of constructive journalism
- Server-side classification with Redis caching for performance

### 🔧 Technical Improvements
- Added `SemanticClassifier` class for batch API calls
- SHA-256 content hashing for cache deduplication
- Async classification doesn't block page rendering
- Graceful fallback when API is unavailable
- Added host permission for Railway backend

### 📊 Classification Flow
1. Keyword-based scoring (immediate, on-device)
2. Score ≥ 70: Block immediately
3. Score < 70: Queue for semantic classification
4. Semantic classifier provides binary decision: blocked or allowed

---

## v1.1.0 - 2026-02-02

### 🌲 Rebranding
- **New name**: "Šumski Filter" (Forest Filter)
- **New tagline**: "🌲 Čuva tvoju energiju za stvari koje možeš da promeniš"
- Forest-themed positive messages when articles are hidden
- Complete visual identity update with forest emojis 🌲🌿🍃

### 🐛 Critical Bug Fix
- **Fixed Serbian character detection**: JavaScript `\b` word boundary doesn't work with Serbian characters (č, ć, ž, š, đ)
- Created `srbWord()` helper function with Unicode-aware lookbehind/lookahead patterns
- Now correctly detects: Vučić, Brnabić, Dačić, Đedović, Šapić, etc.

### ✨ New Features
- **Added Đedović Handanović**: Minister of Mining and Energy now detected
- **20 new curated forest images**: Beautiful Serbian nature photography
- **Forest-themed messages**:
  - 🌲 Preskočili smo ovu vest za vas
  - 🌿 Fokusirajte se na ono što možete da promenite
  - 🍃 Vaša energija je sačuvana
  - 🌳 Uživajte u tišini šume
  - 🌲 Manje buke, više mira
  - 🍂 Ova vest nije vredna vaše pažnje
  - 🌿 Idemo dalje, ka lepšim stvarima
  - 🌲 Šuma filtrira buku

### 🧹 Codebase Cleanup
- Removed unused files: `content.js`, `content-loader.js`
- Removed unused folders: `modules/`, `sites/`, `test-data/`, `tools/`
- Removed old documentation files
- Removed SVG icons (using PNGs only)
- Clean, minimal file structure

### 📁 Final Structure
```
├── background.js        # Service worker
├── content-bundle.js    # Main detection logic
├── manifest.json        # Extension config
├── popup.html/js        # Popup UI
├── styles.css           # Styles
├── icons/*.png          # PNG icons
├── CHANGELOG.md
├── INSTALLATION.md
└── README.md
```

---

## v1.0.5 - 2026-02-02

### 🎨 New Feature
- **Protest images from protesti.pics**: Replaced Lorem Picsum with actual protest photography
  - Uses images from https://protesti.pics/nema-pregovora
  - "Nema pregovora" collection documenting demonstrations
  - All photographs are free for use to support protests
  - 15+ curated protest images rotate randomly
  - Images hosted on reliable CDN (cdn.myportfolio.com)
  - More meaningful and contextually relevant replacements

### 🔧 Technical
- Updated `PROTEST_IMAGES` array with real protest photography URLs
- Changed image source from `picsum.photos` to `cdn.myportfolio.com`
- Updated manifest `host_permissions` to allow CDN access
- Random selection from protest image collection

---

## v1.0.4 - 2026-02-02

### ✨ New Feature
- **Re-enable blocking button**: Added "🔄 Omogući ponovno blokiranje" button
  - Clears the unhidden articles list
  - Removes `data-bez-vucica-unhidden` attributes from all articles
  - Refreshes page automatically to re-scan and block articles
  - Use this after viewing unhidden articles when you want blocking to work again

### 🔧 Workflow
1. **Unhide**: Click "👁️ Prikaži sve sakrivene vesti" → See what was blocked
2. **Read**: Check the unhidden articles
3. **Re-enable**: Click "🔄 Omogući ponovno blokiranje" → Allow blocking again
4. **Refresh**: Page reloads and articles get blocked based on current threshold

---

## v1.0.3 - 2026-02-02

### 🐛 Critical Fixes
- **Fixed unhide feature**: Articles now stay visible after unhiding (no more blinking)
  - Articles are marked with `data-bez-vucica-unhidden` attribute
  - Unhidden article IDs tracked in memory to prevent re-blocking
  - Longer fade animation (400ms) for smoother transitions
- **Softer button design**: Less aggressive, more muted colors
  - Primary button: `#e8e7df` (warm gray) instead of vibrant orange
  - Success state: `#d4edda` (soft green) instead of bright green
  - Secondary button: More subtle hover states

### 🎨 Design Refinements
- Buttons now use neutral gray tones (Anthropic-style)
- Success message less vibrant, more professional
- Better visual hierarchy without aggressive colors

---

## v1.0.2 - 2026-02-02

### ✨ New Features
- **Unhide Feature**: Added "Prikaži sve sakrivene vesti" button to reveal all hidden articles and see what was actually blocked
  - Success state displays for 10 seconds with article count
  - Smooth animations for better UX feedback
- **Refresh Button**: Quick page refresh from popup
- **Status Indicator**: Subtle pulsing dot (6px) showing filter is active

### 🎨 Design Overhaul - Anthropic-Inspired
Based on actual Anthropic.com design system:

**Colors** (exact Anthropic palette):
- Text: `#131314` (near-black, not pure black)
- Background: `#faf9f0` (warm cream)
- Accent: `#d97757` (terracotta orange)
- Secondary: `#87867f` (slate gray)
- Borders: `#e8e7df` (subtle warm gray)
- Success: `#22c55e` (green)

**Typography**:
- Inter font family with proper font-smoothing
- Restraint in weights (400, 500, 600 only)
- Tabular numbers for statistics
- Letter-spacing: -0.02em on headings

**Layout & Spacing**:
- Minimalist approach with generous whitespace
- Border separators instead of heavy shadows
- 24px container padding
- Consistent 12px gap in grid layouts

**Components**:
- Clean stat cards with 1px borders (no heavy shadows)
- Subtle toggle (44x24px)
- Minimal range slider (4px track, 18px thumb)
- Simple buttons (6px border-radius, not rounded pills)

### 🔧 Improvements
- Removed "lollypop" design elements (no gradients, no heavy shadows)
- Cleaner visual hierarchy with borders instead of elevation
- Professional, minimal aesthetic
- Better stat grid with centered values
- Simplified emoji usage (kept minimal)

### 📊 Technical
- Replacement tracking in adapter using Map data structure
- Unhide functionality with smooth fade animations
- Cleared processed articles set when unhiding for re-scanning capability
- Message passing between popup and content script for unhide action

---

## v1.0.1 - 2026-02-02

### 🐛 Bug Fixes
- Fixed ES module import issues by creating bundled content-bundle.js
- Removed content-loader.js dependency
- Single-file approach for better Chrome extension compatibility

### 📝 Changes
- Migrated to bundled architecture (no ES imports)
- Updated manifest to load content-bundle.js directly
- All classes and logic in one file (KEYWORDS_DB, ToxicityScorer, ToxicDetector, N1InfoAdapter)

---

## v1.0.0 - 2026-02-02

### 🎉 Initial Release

#### Core Features
- **Tier-Based Detection System**:
  - Tier 1: Immediate block (Vučić, SNS) - 100 weight
  - Tier 2: High priority (Brnabić, Vučević, Mali) - 60-85 weight
  - Tier 3: Context-dependent (Pink, Happy, Informer) - 40-70 weight
  - Tier 4: Controversial topics (Rio Tinto, Ekspo, Litijum) - 40-50 weight
  - Whitelist for critical reporting (kritika, suđenje, optužnica)

- **Smart Content Replacement**:
  - Random images from Picsum.photos
  - Smooth fade animations
  - Optional "Vest sakrivena" label
  - Preserves page layout

- **Configurable Settings**:
  - Enable/disable filter toggle
  - Detection threshold slider (0-100)
  - Controversial topics toggle
  - Show/hide label option
  - Settings persist via Chrome Storage

- **Site Adapter Architecture**:
  - Modular, extensible design
  - N1 Info adapter with multiple selectors
  - Base adapter class for future sites
  - Config-driven approach

- **Real-Time Statistics**:
  - Articles scanned counter
  - Articles blocked counter
  - Block rate percentage
  - Live updates every 2 seconds

#### Technical
- Manifest V3 compliant
- Mutation observer for dynamic content
- Chrome Storage API for settings
- Processed article tracking (no double-processing)
- Performance optimized with debounced scanning

#### Supported Sites
- rs.n1info.com
- n1info.rs
- *.n1info.com

---

## Design Philosophy

### Colors (Anthropic's Actual Palette)
- **Text**: #131314 (near-black)
- **Background**: #faf9f0 (warm cream)
- **Accent Orange**: #d97757 (terracotta)
- **Secondary**: #87867f (slate gray)
- **Borders**: #e8e7df (warm gray)
- **Success**: #22c55e (green)

### Typography
- **Font Family**: Inter (Google Fonts)
- **Weights**: 400 (regular), 500 (medium), 600 (semi-bold), 700 (bold)
- **Letter Spacing**: -0.02em for headers

### Spacing & Borders
- **Border Radius**: 12px for cards, 10px for buttons
- **Shadows**: Soft, layered (0 2px 8px rgba(0,0,0,0.06))
- **Padding**: Consistent 16px-20px spacing

---

**Status**: ✅ Production Ready
**Next**: Test unhide feature on live N1 site!
