# 📦 Instalacija - Šumski Filter

## Brza instalacija (2 minuta)

### Korak 1: Otvori Chrome Extensions

1. Otvori Chrome
2. Idi na `chrome://extensions/`
3. Uključi **Developer mode** (toggle gore desno)

### Korak 2: Učitaj ekstenziju

1. Klikni **Load unpacked**
2. Pronađi i izaberi `sumski-filter/` folder
3. Klikni **Select**

### Korak 3: Proveri instalaciju

Trebalo bi da vidiš:
- Karticu sa imenom "Šumski Filter"
- Ikonicu u toolbar-u
- Status bez grešaka

### Korak 4: Testiraj

1. Poseti https://rs.n1info.com/ ili https://n1info.rs/
2. Propagandne vesti će biti zamenjene slikama šume
3. Klikni na ikonicu da vidiš statistiku

## 📁 Struktura fajlova

```
sumski-filter/
├── background.js         # Service worker
├── content-bundle.js     # Glavna logika
├── manifest.json         # Konfiguracija
├── popup.html            # Popup UI
├── popup.js              # Popup logika
├── styles.css            # Stilovi
├── icons/
│   ├── icon16.png
│   ├── icon48.png
│   └── icon128.png
├── CHANGELOG.md
└── README.md
```

## ⚙️ Podešavanja

Klikni na ikonicu ekstenzije da otvoriš popup:

| Opcija | Opis |
|--------|------|
| **Omogući filter** | Uključi/isključi filtriranje |
| **Prag detekcije** | 0-100, veći = strožiji filter |
| **Kontroverzne teme** | Rio Tinto, Ekspo, litijum |
| **Prikaži labelu** | Poruka na sakrivenim vestima |

## 🔄 Ažuriranje

1. Idi na `chrome://extensions/`
2. Pronađi "Šumski Filter"
3. Klikni ikonicu 🔄 (reload)

## ❌ Deinstalacija

1. Idi na `chrome://extensions/`
2. Pronađi "Šumski Filter"
3. Klikni **Remove**

## 🐛 Troubleshooting

### Ekstenzija ne radi?

1. Proveri da li je uključena (toggle ON)
2. Proveri da li si na podržanom sajtu (n1info.rs)
3. Reload-uj stranicu (Ctrl+R)

### Ne vidiš ikonicu?

1. Klikni na puzzle ikonicu u Chrome toolbar-u
2. Pronađi "Šumski Filter"
3. Klikni pin ikonicu

### Vesti se ne filtriraju?

1. Otvori Developer Tools (F12)
2. Idi na Console tab
3. Traži `[Šumski Filter]` logove
4. Proveri da li ima grešaka

## 📊 Console logovi

Kada radi ispravno, videćeš:
```
[Šumski Filter] Initializing...
[Šumski Filter] Using adapter: N1 Info
[Šumski Filter] Found X articles to process
[Šumski Filter] Blocked: "Vučić najavio..." (score: 100)
[Šumski Filter] Stats: X/Y blocked (Z%)
```

---
