# 🌲 Šumski Filter - Chrome Extension

Chrome ekstenzija koja čuva tvoju energiju za stvari koje možeš da promeniš. Automatski sakriva frustrirajuće vesti i prikazuje slike prirode.

## ✨ Funkcije

- 🌲 **Pametna detekcija** - Tiered keyword scoring (političari → tabloidi → propaganda fraze)
- 🧠 **Semantički fallback** - Server-side klasifikacija za neblokirane članke (uključena podrazumevano)
- 🖼️ **Slike prirode** - Umesto negativnih vesti, prikazuje lepe šume i pejzaže
- ⚙️ **Konfigurabilan** - Podesi prag detekcije po svojoj meri
- 📊 **Statistika** - Prati koliko vesti je filtrirano (i AI statistiku)
- 🔄 **Unhide opcija** - Pogledaj sakrivene vesti kad hoćeš

## 📦 Instalacija

1. Otvori Chrome i idi na `chrome://extensions/`
2. Uključi **Developer mode** (gore desno)
3. Klikni **Load unpacked**
4. Izaberi `sumski-filter/` folder
5. Gotovo

Za detalje vidi `INSTALLATION.md`.

## 🎯 Upotreba

1. Poseti `rs.n1info.com` ili `n1info.rs`
2. Ekstenzija automatski filtrira vesti
3. Klikni na ikonicu da vidiš statistiku i podesiš opcije

## ⚙️ Podešavanja

- **Omogući filter** - Uključi/isključi filtriranje
- **Prag detekcije** - Osetljivost filtera (0-100)
- **Kontroverzne teme** - Filtriraj Rio Tinto, Ekspo, litijum
- **Prikaži labelu** - Poruka na sakrivenim vestima

## 🔍 Šta filtrira?

### Tier 1 - Core regime
- Vučić, SNS, Brnabić, Vučević, Dačić

### Tier 2 - Režimski funkcioneri
- Ministri i stranački funkcioneri

### Tier 3 - Pro-režimski mediji
- Pink, Informer, Kurir, Alo

### Tier 4 - Propaganda fraze
- "Predsednik poručio", Rio Tinto, Ekspo, litijum

### Tier 5 - Politička buka
- Opozicione svađe i senzacionalizam

## 🛡️ Whitelist

Bitne vesti prolaze kroz filter:
- Hapšenja, presude, istrage
- Tragedije, žrtve
- Nadstrešnica u Novom Sadu

## 📁 Struktura

```
sumski-filter/
├── background.js         # Service worker
├── content-bundle.js     # Glavna logika detekcije + semantic client
├── manifest.json         # Extension konfiguracija (Manifest V3)
├── popup.html            # Popup UI
├── popup.js              # Popup logika
├── styles.css            # Stilovi
├── icons/                # PNG ikonice
├── CHANGELOG.md          # Istorija verzija
├── INSTALLATION.md       # Detaljna instalacija
└── README.md             # Ovaj fajl
```

## ✅ Podržani sajtovi

- rs.n1info.com
- n1info.rs

## 📝 License

MIT

*Čuva tvoju energiju za stvari koje možeš da promeniš* 🌲
